unit UnitMm7;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AXmsCtrl_TLB, StdCtrls, ShellAPI, ExtCtrls;

type
  TFormMm7 = class(TForm)
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    EditResult: TEdit;
    EditResponse: TEdit;
    EditLogfile: TEdit;
    ButtonLoadCfg: TButton;
    ButtonSaveCfg: TButton;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    ButtonSend: TButton;
    EditTo: TEdit;
    EditSubject: TEdit;
    EditBody: TMemo;
    EditImage: TEdit;
    ButtonBrowse: TButton;
    ButtonView: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    Label1: TLabel;
    EditURL: TEdit;
    CheckSSL: TCheckBox;
    CheckAuthentication: TCheckBox;
    LabelAccount: TLabel;
    LabelPassword: TLabel;
    EditAccount: TEdit;
    EditPassword: TEdit;
    Panel1: TPanel;
    Panel2: TPanel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    ComboVariation: TComboBox;
    ComboSchema: TComboBox;
    ComboVersion: TComboBox;
    function GetResult : Integer;
    procedure EnableControls ();
    procedure FormCreate(Sender: TObject);
    procedure ButtonViewClick(Sender: TObject);
    procedure ButtonSendClick(Sender: TObject);
    procedure ButtonLoadCfgClick(Sender: TObject);
    procedure ButtonSaveCfgClick(Sender: TObject);
    procedure ButtonBrowseClick(Sender: TObject);
    function GetTempDirectory: string;
    procedure CheckAuthenticationClick(Sender: TObject);
   private
    objConnection : IMmsProtocolMm7;
    objMessage    : IMmsMessage;
    objSlide      : IMmsSlide;
    objConstants  : IMmsConstants;
  public
    { Public declarations }
  end;

var
  FormMm7: TFormMm7;

implementation

{$R *.dfm}
{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm7.FormCreate(Sender: TObject);
begin
  objConnection    := TMmsProtocolMm7.Create(Application).DefaultInterface;
  objMessage       := TMmsMessage.Create(Application).DefaultInterface;
  objSlide         := TMmsSlide.Create(Application).DefaultInterface;
  objConstants     := TMmsConstants.Create(Application).DefaultInterface;

  ComboVariation.Items.Add ('3GPP');
  ComboVariation.Items.Add ('Ericsson');
  ComboVariation.Items.Add ('PAP');
  ComboVariation.ItemIndex := 0;

  ComboSchema.Items.Add ('REL-5-MM7-1-0');
  ComboSchema.Items.Add ('REL-5-MM7-1-1');
  ComboSchema.Items.Add ('REL-5-MM7-1-2');
  ComboSchema.Items.Add ('REL-5-MM7-1-3');
  ComboSchema.Items.Add ('REL-5-MM7-1-4');
  ComboSchema.Items.Add ('REL-5-MM7-1-5');
  ComboSchema.Items.Add ('REL-6-MM7-1-0');
  ComboSchema.Items.Add ('REL-6-MM7-1-1');
  ComboSchema.Items.Add ('REL-6-MM7-1-2');
  ComboSchema.Items.Add ('REL-6-MM7-1-3');
  ComboSchema.ItemIndex := 0;

  ComboVersion.Items.Add ( '5.2.0' );
  ComboVersion.Items.Add ( '5.3.0' );
  ComboVersion.Items.Add ( '5.4.0' );
  ComboVersion.Items.Add ( '5.5.0' );
  ComboVersion.Items.Add ( '5.6.0' );
  ComboVersion.Items.Add ( '5.7.0' );
  ComboVersion.Items.Add ( '5.8.0' );
  ComboVersion.Items.Add ( '5.9.0' );
  ComboVersion.Items.Add ( '5.10.0' );
  ComboVersion.Items.Add ( '5.11.0' );
  ComboVersion.Items.Add ( '6.0.0' );
  ComboVersion.Items.Add ( '6.1.0' );
  ComboVersion.Items.Add ( '6.2.0' );
  ComboVersion.Items.Add ( '6.3.0' );
  ComboVersion.Items.Add ( '6.4.0' );
  ComboVersion.Items.Add ( '6.5.0' );
  ComboVersion.Items.Add ( '6.6.0' );
  ComboVersion.Items.Add ( '6.7.0' );
  ComboVersion.ItemIndex := 0;

  EnableControls ();

  GetTempDirectory ();
end;

{ //////////////////////////////////////////////////////////////////////////////// }

function TFormMm7.GetResult : Integer;
begin
  Result := objConnection.LastError;

  EditResponse.Text   := objConnection.ProviderResponse;
  EditResult.Text     := 'ERROR ' + IntToStr ( Result ) +  ' : ' + objConnection.GetErrorDescription( Result );
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm7.ButtonViewClick(Sender: TObject);
var LogFile : PAnsiChar;
begin
  LogFile := StrNew(PChar(EditLogfile.Text));

  ShellExecute ( 0, 'open' , LogFile, '', '', SW_SHOW );
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm7.ButtonSendClick(Sender: TObject);
var vtVar : OleVariant;
begin
  ButtonSend.Enabled := False;
  Cursor := crHourGlass;

  { Set Connection Properties }
  objConnection.Clear ();

  objConnection.ProviderURL         := EditURL.Text;
  objConnection.ProviderWebAccount  := EditAccount.Text;
  objConnection.ProviderWebPassword := EditPassword.Text;
  objConnection.ProviderMM7Version  := ComboVersion.ItemIndex;
  objConnection.ProviderMM7Schema   := ComboSchema.ItemIndex;
  objConnection.ProviderMM7Variation:= ComboVariation.ItemIndex;
  objConnection.LogFile             := EditLogfile.Text;

  if ( CheckSSL.Checked = true ) then begin
    objConnection.ProviderUseSSL := 1;
  end;

  { Set Message Properties }
  objMessage.AddRecipient(EditTo.Text, objConstants.asMMS_RECIPIENT_TO);
  objMessage.Subject                := EditSubject.Text;

  { Create First Slide }
  vtVar := 0;

  objSlide.AddText(EditBody.Text);
  objSlide.AddAttachment (EditImage.Text, vtVar );

  vtVar := objSlide;
  objMessage.AddSlide(vtVar);

  vtVar := objMessage;

  { Send the message }
  objConnection.Send(vtVar);

  GetResult ();

  ButtonSend.Enabled := True;
  Cursor := crDefault;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm7.ButtonLoadCfgClick(Sender: TObject);
begin
  OpenDialog.DefaultExt := '.mm7';
  OpenDialog.Filter     := 'MMS Connection Files|*.mm7';

  if OpenDialog.Execute = true Then begin
    objConnection.LogFile := EditLogfile.Text;
    objConnection.ProviderLoadConfig (OpenDialog.FileName);

    if ( GetResult() = 0) then begin
      EditURL.Text                    := objConnection.ProviderURL;
      EditAccount.Text                := objConnection.ProviderWebAccount;
      EditPassword.Text               := objConnection.ProviderWebPassword;
      ComboVersion.ItemIndex          := objConnection.ProviderMM7Version;
      ComboSchema.ItemIndex           := objConnection.ProviderMM7Schema;
      ComboVariation.ItemIndex        := objConnection.ProviderMM7Variation;

      CheckSSL.Checked                := Boolean (objConnection.ProviderUseSSL);

      if ( StrLen ( PChar(EditAccount.Text) ) > 0  ) then begin
        CheckAuthentication.Checked := true;
      end;
    end;
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm7.ButtonSaveCfgClick(Sender: TObject);
begin
  SaveDialog.DefaultExt := '.mm7';
  SaveDialog.Filter     := 'MMS Connection Files|*.mm7';

  if SaveDialog.Execute = true then begin
    objConnection.ProviderURL         := EditURL.Text;
    objConnection.ProviderWebAccount  := EditAccount.Text;
    objConnection.ProviderWebPassword := EditPassword.Text;
    objConnection.ProviderMM7Version  := ComboVersion.ItemIndex;
    objConnection.ProviderMM7Schema   := ComboSchema.ItemIndex;
    objConnection.ProviderMM7Variation:= ComboVariation.ItemIndex;
    objConnection.ProviderUseSSL      := Integer (CheckSSL.Checked);

    objConnection.ProviderSaveConfig(SaveDialog.FileName);

    GetResult ();
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm7.ButtonBrowseClick(Sender: TObject);
begin
  OpenDialog.DefaultExt := '.jpg';
  OpenDialog.Filter     := 'Image Files|*.jpg';

  if OpenDialog.Execute = true Then begin
    EditImage.Text := OpenDialog.FileName;
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

function TFormMm7.GetTempDirectory: string;
var Buffer: array[0..MAX_PATH] of Char;
begin
  GetTempPath(SizeOf(Buffer) - 1, Buffer);
  EditLogfile.Text := StrPas(Buffer) + 'MmsLog.txt';
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm7.EnableControls ();
begin
  LabelAccount.Enabled  := CheckAuthentication.Checked;
  LabelPassword.Enabled := CheckAuthentication.Checked;
  EditAccount.Enabled   := CheckAuthentication.Checked;
  EditPassword.Enabled  := CheckAuthentication.Checked;
end;
{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm7.CheckAuthenticationClick(Sender: TObject);
begin
  EnableCOntrols();
end;

{ //////////////////////////////////////////////////////////////////////////////// }

end.
